*================================================================*
* SAS programmer: James Nguyen, USEPA                            *
*                                                                *
* Project: OP inhibition studies                                 *
*                                                                *
* Chemical: PhorateOxonSulfone                              *
*                                                                *
* Descriptions:                                                  *
*     - run the selected (Exponent) final models                 *
*     - perform regression diagnostics                           *
*     - calculated ki values from human vs. rat analysis         *
*                                                                *
* Date: March 2020                                               *
*===============================================================*;
option formdlim="=" ls=100 ps=100 nodate nonumber;

%include "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Newcode\Diagnostics3.SAS";

libname EPA "C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\kapp data";


/****************************************************************************/
/* Final NLMIXED Model                                                      */
/****************************************************************************/

data PhorateOxonSulfone;
     set epa.PhorateOxonSulfone;
run;
proc sort data=PhorateOxonSulfone;
     by id;
run;

/*
ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfone - individual sample curves.resids.rtf" startpage=no;
%scatter_plot(chemical=PhorateOxonSulfone);
ods rtf close;
*/

*===> Human vs. Rat;

title "Human vs. Rat: final model 3";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_HR;
PROC NLMIXED data=PhorateOxonSulfone  method=firo tech=newrap lis=3 maxiter=20000 /* gconv=0 */;
      PARMS ha=1.2
			hb=1.5
			ra=0.7
			rb=0.8
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			gr1=0.1 0.5 0.9 gr12=0.1 0.5 0.9 gr2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best = 50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
			gra=gr1*gr1;
			grab=gr1*gr12;
			grb=gr12*gr12+gr2*gr2;
            rha=ha+uha;
			rra=ra+ura;
            rhb=hb+uhb;
			rrb=rb+urb;
            PRED2 = (rha*H_I__M + rra*R_I__M)/(rhb*Human*1e-5 + H_I__M + rrb*Rat*1e-5 + R_I__M);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ura urb ~ normal([0, 0, 0, 0],	[gha, 
												 		 ghab, ghb,
														 0,    	  0,   gra,
														 0,       0,   grab, grb]) SUBJECT=ID out=RandID_HR; 
	  ESTIMATE "human/rat" (ha/hb)/(ra/rb);
	  ESTIMATE 'human ki' (ha/hb);
      ESTIMATE 'rat ki' (ra/rb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  estimate "gra" gr1*gr1;
	  estimate "grab" gr1*gr12;
	  estimate "grb" gr12*gr12+gr2*gr2;
	  id pred2;
	  Predict PRED2 out=Resid_HR;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfone human-rat.resids.rtf" startpage=no;
%DiagnosticsHR(chemical=PhorateOxonSulfone, model=3)
ods rtf close;
*%Calculate_Ki(chemical=TerbufosOxonSulfoxide, Hadj=1e-4, Radj=1e-4);

*===> Adult vs. Infant;
/* Using model 2 since could not get model 3 to converge */


title "final model 2b - Adult (>=10 yr) vs. Infant";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_AI;
PROC NLMIXED data=PhorateOxonSulfone(where=(Human=1))  tech=nrridg lis=3 maxiter=100000 method=firo;
      PARMS ada=1.3	adB=0.1 0.5 0.9
			ia=1.1 iB=0.1 0.5 0.9
			ga1=0.1 0.5 0.9 	ga12=0.1 0.5 0.9	ga2=0.1 0.5 0.9
			S2E=0.1 0.5 0.9 / best=50;
			gada=ga1*ga1;
			gadab=ga1*ga12/10;
			gadb=ga12*ga12/100+ga2*ga2/100;
			rada=ada+uha;
			ria=ia+uha;
            radb=adB+uhb;
			rib=iB+uhb;
            PRED2 = (rada*H_I__M*adult + ria*H_I__M*infant)/(radb*adult*1e-4 + H_I__M*adult + rib*1e-4*infant + H_I__M*infant);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-3);

     RANDOM  uha uhb ~ normal([0, 0],   [gada, 
														gadab, gadb 
														]) SUBJECT=ID out=RandID_AI;
	 ESTIMATE "Adult/Infant ki" (ada/adb)/(ia/ib);
	  ESTIMATE 'Adult ki' (ada/adb);
      ESTIMATE 'Infant ki' (ia/ib);
  	  estimate "gada" ga1*ga1;
	  estimate "gadab" ga1*ga12/10;
	  estimate "gadb" ga12*ga12/100+ga2*ga2/100;
	  id pred2;
	   predict pred2 out=Resid_AI;
run;

%let factor=0.001;


ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfone Adult-Infant.resids.rtf" startpage=no;
%DiagnosticsAI(chemical=PhorateOxonSulfone, model=2)
ods rtf close;

*===> Male vs. Female;

/* Could not get model 3 to converge (previous version had an impossible covaraince matriox for males). Switching to model 2 */

/* 
title "final model 3 - male vs. female";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_MF;
PROC NLMIXED data=PhorateOxonSulfone(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000 method=firo;
      PARMS ma=0.1 0.5 0.9 1.4 mb= 0.1 0.5 0.9 1.4
			fa=0.1 0.5 0.9 1.4 fB=0.1 0.5 0.9 1.4
			gm1=0.1 0.5 0.9 gm12=0.1 0.5 0.9 gm2=0.1 0.5 0.9
			gf1=0.1 0.5 0.9 gf12=0.1 0.5 0.9 gf2=0.1 0.5 0.9
			S2E=.1 .5 .9 1.4 / best=50;
			gma=gm1*gm1;
			gmab=gm1*gm12/10;
			gmb=gm12*gm12/100+gm2*gm2/100;
			gfa=gf1*gf1;
			gfab=gf1*gf12/10;
			gfb=gf12*gf12/100+gf2*gf2/100;
            rma=ma+uma;
			rfa=fa+ufa;
            rmb=mB+umb;
			rfb=fB+ufb;
           PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-4+ H_I__M*male + rfb*female*1e-4 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uma umb ufa ufb ~ normal([0, 0, 0, 0],   [gma, 
														gmab, gmb, 
														0,    0,     gfa, 
														0,    0,     gfab,   gfb]) SUBJECT=ID out=RandID_MF; 

	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
  	  estimate "gma" gm1*gm1;
	  estimate "gmab" gm1*gm12/10;
	  estimate "gmb" gm12*gm12/100+gm2*gm2/100;
  	  estimate "gfa" gf1*gf1;
	  estimate "gfab" gf1*gf12/10;
	  estimate "gfb" gf12*gf12/100+gf2*gf2/100;
	  id pred2;
	  predict pred2 out=Resid_MF;
run;

%let factor=0.0001;
*/

ods output ParameterEstimates=parm_MF;

PROC NLMIXED data=PhorateOxonSulfone(where=(Human=1)) method=firo  /* itdetails */ tech=newrap maxiter=100000;
      PARMS ma=.1 .5 .9 1.4 mb= .1 .5 .9 1.4
			fa=.1 .5 .9 1.4 fb=.1 .5 .9 1.4
			gh1=.1 .5 .9 1.4 gh12=.1 .5 .9 1.4 gh2=.1 .5 .9 1.4
			S2E=.1 .5 .9 1.4  / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12/10;
			ghb=gh12*gh12/100+gh2*gh2/100;
			rma=ma+uha;
			rfa=fa+uha;
            rmb=mB+uhb;
			rfb=fB+uhb;
            PRED2 = (rma*H_I__M*male + rfa*H_I__M*female)/(rmb*male*1e-4 + H_I__M*male + rfb*female*1e-4 + H_I__M*female);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_MF; 
	 ESTIMATE "male/female ki" (ma/mb)/(fa/fb);
	  ESTIMATE 'male ki' (ma/mb);
      ESTIMATE 'female ki' (fa/fb);
	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12/10;
	  estimate "ghb" gh12*gh12/100+gh2*gh2/100;
	  id pred2;
		predict pred2 out=Resid_MF;
run;

%let factor=0.0001;
ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfone Male-Female.resids.rtf" startpage=no;
%DiagnosticsMF(chemical=PhorateOxonSulfone, model=2)
ods rtf close;


*===> Caucasian vs. Other Races;

title "Final model 2 - Caucasian vs. Other Race";
*ods select  ParameterEstimates  FitStatistics ConvergenceStatus  AdditionalEstimates;
ods output ParameterEstimates=parm_CO;
PROC NLMIXED data=PhorateOxonSulfone(where=(Human=1)) method=firo  tech=newrap lis=3 maxiter=100000;
      PARMS ca=1.0 cb=1.4
			ora=1.8 orB=1.9
			gh1=0.1 0.5 0.9 gh12=0.1 0.5 0.9 gh2=0.1 0.5 0.9
			S2E=.1 .5 .9 / best=50;
			gha=gh1*gh1;
			ghab=gh1*gh12;
			ghb=gh12*gh12+gh2*gh2;
            rca=ca+uha;
			rora=ora+uha;
            rcb=cB+uhb;
			rorb=orB+uhb;
		PRED2 = (rca*H_I__M*caucasian + rora*H_I__M*otherrace)/(rcb*caucasian*1e-5 + H_I__M*caucasian + rorb*otherrace*1e-5 + H_I__M*otherrace);
      MODEL KAPP ~ NORMAL(PRED2, S2E*1e-4);
      RANDOM  uha uhb ~ normal([0, 0],  [gha, ghab, ghb]) SUBJECT=ID out=RandID_CO;
	 ESTIMATE "Caucasian/Other Race ki" (ca/cb)/(ora/orb);
	  ESTIMATE 'Caucasain ki' (ca/cb);
      ESTIMATE 'Other Race ki' (ora/orb);
  	  estimate "gha" gh1*gh1;
	  estimate "ghab" gh1*gh12;
	  estimate "ghb" gh12*gh12+gh2*gh2;
	  id pred2;
	  predict pred2 out=Resid_CO;
run;

%let factor=0.0001;

ods rtf file="C:\JcohenBACKUP-Destination\toxico\whitepaper\All CEB Analyses\Diagnostics2\PhorateOxonSulfone Caucasian-Other Races.resids.rtf" startpage=no;
%DiagnosticsCO(chemical=PhorateOxonSulfone, model=2)
ods rtf close;

%resids